import {stopPreviousBuilds} from './utils/stopPreviousBuilds';
import {runFailedTests} from './utils/runFailedTests';

require('../utils/prepareEnvVars')();

/**
 * - Останавливаем прошлые билды тестов и упавших тестов
 *
 * - Если e2e тесты можно скипнуть (см. хэлпер tools/pr/utils/verifyE2ESkip), то не ждем билда фермы и запускаем
 * упавшие тесты сразу (для проверки в PR)
 * После этого в teamcity сами тесты уже запускаться не будут (используя скрипт tools/pr/verifyE2ESkip)
 */
(async (): Promise<void> => {
    await stopPreviousBuilds();
    await runFailedTests();
})().catch(err => {
    console.log(err);

    process.exit(1);
});
