import {BUILD_TYPE_PR_FAILED} from '../constants/teamcity';

import {ESkipType, verifySkip} from '../../pr/utils/verifySkip';
import TeamcityApiClient from '../../utils/api/TeamcityApiClient/TeamcityApiClient';
import {getCurrentBranch} from '../../utils/getCurrentBranch';

export async function runFailedTests(): Promise<void> {
    const apiClient = new TeamcityApiClient();
    const currentBranch = getCurrentBranch();

    const {canBeSkipped} = await verifySkip(ESkipType.E2E);

    if (canBeSkipped) {
        await apiClient.runBuild({
            buildTypeId: BUILD_TYPE_PR_FAILED,
            branchName: currentBranch,
        });
    }
}
