import {flatten} from 'lodash';

import {BUILD_TYPE_PR_FAILED, BUILD_TYPE_PR} from '../constants/teamcity';

import TeamcityApiClient from '../../utils/api/TeamcityApiClient/TeamcityApiClient';
import {getCurrentBranch} from '../../utils/getCurrentBranch';

export async function stopPreviousBuilds(): Promise<void> {
    const apiClient = new TeamcityApiClient();
    const currentBranch = getCurrentBranch();

    const buildLocators = flatten(
        ['running', 'queued'].map(state =>
            [BUILD_TYPE_PR, BUILD_TYPE_PR_FAILED].map(buildType => ({
                buildType,
                count: 1e4,
                state,
            })),
        ),
    );
    const runningBuilds = await apiClient.getBuilds(buildLocators);

    const buildsToStop = runningBuilds.filter(
        ({branchName}) => branchName === currentBranch,
    );

    if (!buildsToStop.length) {
        console.log('No builds to stop');

        return;
    }

    const buildIdsToStop = buildsToStop.map(({id}) => id);

    console.log(`Builds to stop: ${buildIdsToStop.join(', ')}`);

    await apiClient.cancelBuilds(buildIdsToStop);
}
