import moment from 'moment';

import {EReleasePage, IClickHouseLighthouseMeasure} from '../types';

import {ROBOT} from '../../../../src/utilities/dateUtils/formats';
import {TClickHouseColumns} from '../../../utils/api/ClickHouseApiClient/ClickHouseApiClient';

const BASE_URL = 'https://travel-test.yandex.ru';
const TEN_DAYS_AHEAD = moment().add(10, 'days').format(ROBOT);
const TWELVE_DAYS_AHEAD = moment().add(12, 'days').format(ROBOT);

export const RELEASE_PAGES_URLS: Record<EReleasePage, string> = {
    [EReleasePage.AVIA_MAIN]: `${BASE_URL}/avia/`,
    [EReleasePage.AVIA_DATE_SEARCH]: `${BASE_URL}/avia/search/result/?adult_seats=1&children_seats=0&fromId=c213&infant_seats=0&klass=economy&oneway=1&return_date=&toId=c2&when=${TEN_DAYS_AHEAD}`,
    [EReleasePage.AVIA_ROUTE]: `${BASE_URL}/avia/routes/moscow--saint-petersburg/`,
    [EReleasePage.AVIA_FLIGHT]: `${BASE_URL}/avia/flights/SU-1404/`,
    [EReleasePage.TRAINS_MAIN]: `${BASE_URL}/trains/`,
    [EReleasePage.TRAINS_DIRECTION_SEARCH]: `${BASE_URL}/trains/moscow--saint-petersburg/`,
    [EReleasePage.TRAINS_DATE_SEARCH]: `${BASE_URL}/trains/moscow--saint-petersburg/?when=${TEN_DAYS_AHEAD}`,
    [EReleasePage.HOTELS_MAIN]: `${BASE_URL}/hotels/`,
    [EReleasePage.HOTELS_DATE_SEARCH]: `${BASE_URL}/hotels/search/?adults=2&bbox=37.39523700000001%2C55.601757~37.782114999999976%2C55.861348&checkinDate=${TEN_DAYS_AHEAD}&checkoutDate=${TWELVE_DAYS_AHEAD}&childrenAges=&geoId=213&navigationToken=0&selectedSortId=relevant-first`,
    [EReleasePage.HOTELS_HOTEL]: `${BASE_URL}/hotels/moscow/metamoskva/?adults=2&checkinDate=${TEN_DAYS_AHEAD}&checkoutDate=${TWELVE_DAYS_AHEAD}&childrenAges=`,
    [EReleasePage.HOTELS_GEO_REGION]: `${BASE_URL}/hotels/moscow/`,
    [EReleasePage.BUSES_MAIN]: `${BASE_URL}/buses/`,
    [EReleasePage.BUSES_DIRECTION_SEARCH]: `${BASE_URL}/buses/moscow--saint-petersburg/`,
    [EReleasePage.BUSES_DATE_SEARCH]: `${BASE_URL}/buses/moscow--saint-petersburg/?date=${TEN_DAYS_AHEAD}`,
    [EReleasePage.BUSES_CITY]: `${BASE_URL}/buses/moscow/`,
};

export const LIGHTHOUSE_RELEASE_METRICS_TABLE_COLUMNS: TClickHouseColumns<IClickHouseLighthouseMeasure> =
    {
        date: 'DateTime',
        platform: 'String',
        version: 'Int32',
        page: 'String',
        score: 'Int8',
        fcp: 'Int32',
        lcp: 'Int32',
        si: 'Int32',
        tti: 'Int32',
        tbt: 'Int32',
        cls: 'Int8',
        mpf: 'Int32',
        ttfb: 'Int32',
        mtw: 'Int32',
        jset: 'Int32',
        ds: 'Int32',
    };
