import {ILighthouseScoreAndMetrics} from '../../types';

export enum EReleasePage {
    AVIA_MAIN = 'avia.main',
    AVIA_DATE_SEARCH = 'avia.dateSearch',
    AVIA_ROUTE = 'avia.route',
    AVIA_FLIGHT = 'avia.flight',

    TRAINS_MAIN = 'trains.main',
    TRAINS_DIRECTION_SEARCH = 'trains.directionSearch',
    TRAINS_DATE_SEARCH = 'trains.dateSearch',

    HOTELS_MAIN = 'hotels.main',
    HOTELS_DATE_SEARCH = 'hotels.dateSearch',
    HOTELS_HOTEL = 'hotels.hotel',
    HOTELS_GEO_REGION = 'hotels.geoRegion',

    BUSES_MAIN = 'buses.main',
    BUSES_DIRECTION_SEARCH = 'buses.directionSearch',
    BUSES_DATE_SEARCH = 'buses.dateSearch',
    BUSES_CITY = 'buses.city',
}

export type TReleasePagesMetrics = PartialRecord<
    EReleasePage,
    ILighthouseScoreAndMetrics
>;

export interface IClickHouseLighthouseMeasure {
    date: string;
    platform: string;
    version: number;
    page: string;
    score: number;
    fcp: number;
    lcp: number;
    si: number;
    tti: number;
    tbt: number;
    cls: number;
    mpf: number;
    ttfb: number;
    mtw: number;
    jset: number;
    ds: number;
}
