import times from 'lodash/times';

import {RELEASE_PAGES_URLS} from '../../constants';

import {EReleasePage, TReleasePagesMetrics} from '../../types';

import measureReleasePages from './measureReleasePages';

export default async function getReleasePagesMetrics(
    concurrentMeasures: number,
    measuresPerPage: number,
): Promise<TReleasePagesMetrics> {
    const pagesMetrics: TReleasePagesMetrics = {};
    const pagesLeft = [...Object.entries(RELEASE_PAGES_URLS)] as [
        EReleasePage,
        string,
    ][];

    await Promise.all(
        times(concurrentMeasures, () =>
            measureReleasePages(
                {
                    iterations: measuresPerPage,
                },
                pagesMetrics,
                pagesLeft,
            ),
        ),
    );

    return pagesMetrics;
}
