import {EReleasePage, TReleasePagesMetrics} from '../../types';
import {ILighthouseCalculateOptions} from '../../../types';

import getPageMetrics from './getPageMetrics/getPageMetrics';

export default async function measureReleasePages(
    options: Pick<ILighthouseCalculateOptions, 'iterations'>,
    pagesMetrics: TReleasePagesMetrics,
    pagesLeft: [EReleasePage, string][],
): Promise<void> {
    const pageInfo = pagesLeft.pop();

    if (!pageInfo) {
        return;
    }

    const [id, url] = pageInfo;

    pagesMetrics[id] = await getPageMetrics({
        url,
        iterations: options.iterations,
    });

    if (pagesLeft.length) {
        await measureReleasePages(options, pagesMetrics, pagesLeft);
    }
}
