import {IClickHouseLighthouseMeasure} from '../types';

import ClickHouseApiClient from '../../../utils/api/ClickHouseApiClient/ClickHouseApiClient';

export default async function hasAlreadyMeasured(
    testingVersion: number,
    lighthouseClickHouseClient: ClickHouseApiClient<IClickHouseLighthouseMeasure>,
): Promise<boolean> {
    return Boolean(
        (
            await lighthouseClickHouseClient.getValues(
                `version='${testingVersion}'`,
            )
        ).length,
    );
}
