import colors from 'colors/safe';

import {ILighthouseScoreAndMetrics} from '../types';

export default function getCompareConsoleColor(
    metricKey: keyof ILighthouseScoreAndMetrics,
    firstMetricValue: number,
    secondMetricValue: number,
): (str: string) => string {
    if (firstMetricValue === secondMetricValue) {
        return colors.reset;
    }

    if (metricKey === 'score') {
        return secondMetricValue > firstMetricValue ? colors.green : colors.red;
    }

    return firstMetricValue > secondMetricValue ? colors.green : colors.red;
}
