import {ESkipType, verifySkip} from './utils/verifySkip';

require('../utils/prepareEnvVars')();

const isValidSkipType = (skipType: unknown): skipType is ESkipType => {
    return Object.values(ESkipType).some(type => type === skipType);
};

(async (): Promise<void> => {
    const skipType = process.env.SKIP_TYPE;

    if (!isValidSkipType(skipType)) {
        throw new Error(`Invalid skip type: ${skipType}`);
    }

    const {canBeSkipped, noSkipFiles} = await verifySkip(skipType);

    if (canBeSkipped) {
        console.log(`${skipType} can be skipped`);
    } else {
        console.log(`${skipType} can't be skipped because of these files:

${noSkipFiles.map(({filename}) => `- ${filename}`).join('\n')}`);

        process.exit(1);
    }
})().catch(err => {
    console.log(err);

    process.exit(1);
});
