const {TIMEOUT, SET_SENSOR_EVENTS} = require('./constants');

const {prepareMessage} = require('./prepareMessage');
const {createSend} = require('./createSend');

const send = createSend(process);

function createSensorSender(sensorType) {
    return function (sensorName, labels, value) {
        return new Promise((resolve, reject) => {
            setTimeout(reject, TIMEOUT);

            const data = {
                name: sensorName,
                labels,
                value,
            };

            send(prepareMessage(sensorType, data), resolve);
        }).catch();
    };
}

const gauge = createSensorSender(SET_SENSOR_EVENTS.SOLOMON_SET_GAUGE);
const counter = createSensorSender(SET_SENSOR_EVENTS.SOLOMON_SET_COUNTER);
const rate = createSensorSender(SET_SENSOR_EVENTS.SOLOMON_SET_RATE);

module.exports = {
    gauge,
    counter,
    rate,
};
