import {groupBy, sumBy} from 'lodash';

import getHistory from '../client/getHistory';

(async function getAuthorRating(): Promise<void> {
    const {data: history} = await getHistory();

    const groupedCommits = groupBy(history.commits, commit => commit.author);

    const rating = Object.entries(groupedCommits)
        .map(([author, commits]): [string, number] => [author, commits.length])
        .sort((a, b) => b[1] - a[1]);

    rating.forEach(([author, commitCount]) => {
        console.log(`${author} ${commitCount}`);
    });

    const developers = [
        'maxim-urukov',
        'eccentric74',
        'hazam',
        'atooxa',
        'ndru',
        'a-drobot',
        'nskulikov',
        'isaven',
        'graf-m',
        'metromdouble',
        'elyoskin',
        'stan-nikitin',
        'garifullin-im',
        'sirinity13',
        'w100',
        'almishenko',
        'race',
        'Tanker',
    ];

    const developersCommitCount = sumBy(rating, ([author, commitCount]) => {
        if (developers.includes(author)) {
            return commitCount;
        }

        return 0;
    });
    const allCommitCount = sumBy(rating, ([, commitCount]) => {
        return commitCount;
    });

    console.log(
        `Developer commits/All commits: ${developersCommitCount}/${allCommitCount}`,
    );

    console.log(`Developers part: ${developersCommitCount / allCommitCount}`);
})();
