import {AxiosPromise} from 'axios';

import {TRAVEL_TANKER_BRANCH, TRAVEL_TANKER_PROJECT} from './constants';

import {TSHA1Hash} from './types/TSHA1Hash';

import axiosInstance from './instance';

interface ITankerCommit {
    sha1: TSHA1Hash;
    parents: TSHA1Hash[];
    author: string;
    date: string;
    message: string;
    tree: TSHA1Hash;
}

interface IHistoryResponse {
    last: TSHA1Hash;
    from: TSHA1Hash;
    commits: ITankerCommit[];
}

export default function getHistory(): AxiosPromise<IHistoryResponse> {
    return axiosInstance.get<IHistoryResponse>('history/', {
        params: {
            ['project-id']: TRAVEL_TANKER_PROJECT,
            json: true,
            ref: TRAVEL_TANKER_BRANCH,
        },
    });
}
