import {resolve} from 'path';
import fse from 'fs-extra';
import {mapValues, pickBy} from 'lodash';
import getFunctionName from '@yandex-data-ui/i18n-ts/client/getFunctionName';

import {rootPath, srcPath} from '../../../webpack/utilities/getPathParams';
import {processFiles} from './utilities/processFiles/processFiles';
import getTmpDirPath from './utilities/getTmpDirPath';

import {readFromFiles} from '../readFromFilesAndBuild/readFromFiles';

const OUTPUT = resolve(getTmpDirPath(), 'used-tanker-keys.json');

const folders = [srcPath, resolve(rootPath, 'server')];
const usedKeysets = processFiles(folders);

(async (): Promise<void> => {
    const translations = await readFromFiles();

    let usedKeys = mapValues(translations.keySets, keySet => {
        const keySetUsages = usedKeysets.preciseUsages[keySet.name];

        const used = pickBy(keySet.keys, key => {
            return keySetUsages?.[getFunctionName(key.name)];
        });

        if (!Object.keys(used).length) {
            return {};
        }

        return mapValues(used, () => true);
    });

    usedKeys = pickBy(usedKeys, keySet => Object.keys(keySet).length);

    await fse.ensureDir(getTmpDirPath());

    await fse.writeFile(OUTPUT, JSON.stringify(usedKeys));
})().catch(e => {
    console.error(e);

    process.exit(1);
});
