import {sum} from 'lodash';

import getTankerUrl from './getTankerUrl';

interface IRenderDeltaHtmlOptions {
    description?: string;
    title?: string;
}

export default function renderKeySetListHtml(
    keySets: Record<string, Record<string, string>>,
    fullKeySetNames: string[],
    {description, title}: IRenderDeltaHtmlOptions,
): string {
    const keySetsCount = Object.keys(keySets).length + fullKeySetNames.length;
    const keysCounts = sum(
        Object.values(keySets).map(keySet => Object.keys(keySet).length),
    );

    return `<!doctype html>
<html>
    <head>
        <meta charset="utf-8">
        <title>${title}</title>
    </head>
    <body>
        <p>${description}</p>
        ${fullKeySetNames.length ? `<h2>Full keySets</h2>` : ''}
        <ul>
        ${fullKeySetNames
            .map(keySetName => {
                const url = getTankerUrl(keySetName);

                return `<li><a href="${url}" target="_blank">${keySetName}</a></li>`;
            })
            .join('\n')}
        </ul>
        ${Object.entries(keySets)
            .map(([keySetName, keySet]) => {
                return `
                <h3>${keySetName}</h3>
                <ul>
                    ${Object.entries(keySet)
                        .map(([keyName, url]) => {
                            return `<li><a href="${url}" target="_blank">${keyName}</a></li>`;
                        })
                        .join('\n')}
                </ul>
            `;
            })
            .join('\n')}
        <p>Total: ${keysCounts} keys / ${keySetsCount} keysets</p>
    </body>
</html>
`;
}
