export interface ITeamcityTestOccurrences {
    count: number;
    passed?: number;
    failed?: number;
    ignored?: number;
}

export interface ITeamcityBuildShort {
    id: number;
    buildTypeId: string;
    number: string;
    status: 'FAILURE' | 'SUCCESS';
    state: 'queued' | 'running' | 'finished';
    branchName: string;
    href: string;
    webUrl: string;
    finishOnAgentDate: string;
    customized: boolean;
}

export interface ITeamcityBuildLong extends ITeamcityBuildShort {
    startDate: string;
    testOccurrences?: ITeamcityTestOccurrences;
}

export interface ITeamcityGetBuildsResponse {
    count: number;
    href: string;
    build: ITeamcityBuildShort[];
}

export interface IBuildCancelRequest {
    comment?: string;
    readdIntoQueue?: boolean;
}

export interface IRunBuildParams {
    buildTypeId: string;
    branchName: string;
}
