const fs = require('fs');
const path = require('path');

const {version} = require('../package.json');

module.exports = () => {
    let buildVersion;

    try {
        buildVersion = fs.readFileSync(
            path.join(__dirname, '../.build'),
            'utf8',
        );
    } catch (e) {
        throw new Error('Не найден файл ".build"', e);
    }

    if (!buildVersion || !buildVersion.trim()) {
        throw new Error('Не установлен номер билда');
    }

    return `${version}-${buildVersion.replace(/[\r\n]+/g, '')}`;
};
