const path = require('path');
const url = require('url');
const fs = require('fs');

const config = require('../../.config');

// eslint-disable-next-line security/detect-non-literal-fs-filename
const rootPath = fs.realpathSync(process.cwd());
const nodeModulesPath = path.join(rootPath, 'node_modules');
const srcPath = path.join(rootPath, 'src');
const buildPath = path.join(rootPath, 'build');
const publicFilesPath = path.join(rootPath, 'public');
const clientBuildPath = path.join(buildPath, 'client');
const serverBuildPath = path.join(buildPath, 'server');
const stylesPath = path.join(srcPath, 'styles');

const prerequisitesPath = path.join(srcPath, 'prerequisites');
const i18nPath = path.join(prerequisitesPath, 'i18n');
const holidaysPath = path.join(prerequisitesPath, 'holidays');
const themeBuildPath = path.join(prerequisitesPath, 'theme', 'default.css');

const htmlPath = 'html';

const htmlInputPath = path.join(publicFilesPath, htmlPath);

const freezePath = url.resolve(
    config.static.provider,
    config.static.freezePath,
);
const staticPath = url.resolve(
    config.static.provider,
    config.static.staticPath,
);

const excludeNodeModulesRegExpPath = /node_modules\/(?!(@yandex-lego)\/).*/;
const includeYandexMessengerRegExpPath =
    /node_modules\/@yandex-int\/messenger.widget\/lib\/ui\/popup.css/;

module.exports = {
    srcPath,
    rootPath,
    i18nPath,
    buildPath,
    stylesPath,
    nodeModulesPath,
    clientBuildPath,
    serverBuildPath,
    excludeNodeModulesRegExpPath,
    includeYandexMessengerRegExpPath,
    htmlInputPath,
    freezePath,
    staticPath,
    holidaysPath,
    themeBuildPath,
};
