/**
 * Возвращает суффикс для файлов статики, в котором хранится название ветки, на которой запущен стенд.
 *
 * Нужно, чтобы понимать, на какой стенд проксировать статику при заходе с прокси для асессоров.
 * Решение с кукой не всегда работает, т.к. сафари шлет запросы за статикой без кук.
 */
function getStaticFileNameSuffix() {
    if (process.env.APP_ENV !== 'beta') {
        return '';
    }

    const farmId = process.env.PWD.match(/\/farm\/ya-travel\/(.*)/)[1];

    return `?farmId=${farmId}`;
}

module.exports = getStaticFileNameSuffix;
