const nodeEnv = process.env.NODE_ENV;
const buildLang = process.env.BUILD_LANG || 'ru';
const isBuildBundleAnalyzer = process.env.BUILD_BUNDLE_ANALYZER;
const buildAnalyzerMode = process.env.BUILD_ANALIZER_MODE || 'static';
const serverSourceMap = process.env.SERVER_SOURCE_MAP || false;
const isProduction = nodeEnv === 'production';
const isDevelopment = nodeEnv !== 'production';
const developmentBuildProjects = process.env.DEVELOPMENT_BUILD_PROJECTS;
const withHotReload = process.env.WITH_HOT_RELOAD === 'true';
const buildParallelLimit = process.env.FORCE_WORKERS_COUNT
    ? Number(process.env.FORCE_WORKERS_COUNT)
    : true;
const isThemekitDebug = Number(process.env.DEBUG_LEGO_THEMEKIT) === 1;
const isStorybookBuild = process.env.APP_ENV === 'storybook';
const consoleReduxDevTools = process.env.TRAVEL_CONSOLE_REDUX_DEV_TOOLS;

module.exports = {
    isProduction,
    isDevelopment,
    isBuildBundleAnalyzer,
    buildAnalyzerMode,
    buildLang,
    nodeEnv,
    serverSourceMap,
    developmentBuildProjects,
    withHotReload,
    buildParallelLimit,
    isThemekitDebug,
    isStorybookBuild,
    consoleReduxDevTools,
};
