import { TLabel } from "../Labels/ILabel";
import { EKind } from "./types/EKind";
import { Sensor } from "./Sensor";
import { ISerialValue } from "./types/ISerialValue";
import { timestamp } from "../utils/timestamp";
import { ISerialValueSensor } from "./types/ISerialValueSensor";

export class CounterLike implements Sensor<ISerialValueSensor> {
    private readonly values: ISerialValue[] = [];

    protected constructor(
        private readonly labels: TLabel,
        private readonly kind: EKind,
    ) {}

    private getLastValue = () => this.values[this.values.length - 1]

    private initValue = (value: number = 0) => {
        this.values.push({
            value,
            ts: timestamp(),
        });
    }

    public inc = () => {
        const serialValue = this.getLastValue();

        if (!serialValue) {
            this.initValue(1);
        } else {
            serialValue.value++;
        }
    }

    public addValue = (value: number) => {
        this.values.push({
            value,
            ts: timestamp(),
        })
    }

    public serialize = (): ISerialValueSensor => {
        return {
            kind: this.kind,
            timeseries: this.values.map(value => ({...value})),
            labels: {
                ...this.labels,
            }
        }
    }

    public hasValues = () => this.values.length > 0;

    public reset = () => {
        this.values.length = 0;
    }
}
