import { TLabel } from "../Labels/ILabel";
import { timestamp } from "../utils/timestamp";
import { EKind } from "./types/EKind";
import { ISerialValue } from "./types/ISerialValue";
import { ISerialValueSensor } from "./types/ISerialValueSensor";
import { Sensor } from "./Sensor";

export class Gauge implements Sensor<ISerialValueSensor> {
    private readonly kind = EKind.GAUGE;
    private readonly values: ISerialValue[] = [];

    constructor(private readonly labels: TLabel) {}

    public addValue = (value: number) => {
        this.values.push({
            value,
            ts: timestamp(),
        })
    }

    public serialize = (): ISerialValueSensor => {
        return {
            kind: this.kind,
            timeseries: this.values.map(value => ({...value})),
            labels: {
                ...this.labels,
            }
        }
    }

    public hasValues = () => this.values.length > 0;

    public reset = () => {
        this.values.length = 0;
    }
}
