# Спецификации (некоторых) страниц Яндекс.Путешествий

[![oko health](https://oko.yandex-team.ru/badges/repo.svg?repoName=travel/frontend/spec&vcs=arc)](https://oko.yandex-team.ru/arc/travel/frontend/spec)
[![oko vulnerabilities](https://oko.yandex-team.ru/badges/repoSecurity.svg?repoName=travel/frontend/spec&vcs=arc)](https://oko.yandex-team.ru/arc/travel/frontend/spec)

Данная спецификация необходима для синхронизации разработки между командами фронта и бэка.

## Что нужно знать про спецификацию

### Разработка

Для автоматической проверки типов и автоформатирования кода, перед разработкой нужно:

1. при необходимости [установить nodejs](https://nodejs.org/ru/download/package-manager/);
2. выполнить `npm ci`.

TLDR для проверки code-style

```
cd $ARCADIA/travel/frontend/spec
brew install node@12
npm i  # поставить зависимости
npm run prettier:check  # проверить code-style
npm run prettier:write  # пофиксить code-style
```

### Работа над спецификацией

Спецификация - это простой технический контракт по взаимодействию фронтенда и бекенда в рамках одной страницы пользователя. Хорошая спецификация включает в себя:

-   постановку задачи,
-   желаемые характеристики решения (например, трекинг действий пользователя по логам; или сходимость протокола синхронизации данных о множестве объектов),
-   модели запроса, ответа, и связных данных,
-   ограничения на данные (критерии валидации),
-   описания возможных ошибок и реакций на них,
-   описание протокола (правила и порядок запросов-ответов; например, протокол поллинга при поиске отелей).

Целью спецификации **является** прояснение вышеуказанных аспектов взаимодействия фронтенда и бекенда для скоординированной работы, для уменьшения числа ошибок и правок.

Целью спецификации **не является** получение абсолютно строгого и формального документа, или получение документов для мета-автоматизации по генерации кода обработки/типизации/валидации запросов/ответов.

> **NB** Тем не менее здесь стоит оговориться, что формат описания существует и желательно ему следовать. Кроме того спецификация подразумевает, что любые изменения во взаимодействии в первую очередь будут прорабатываться в ней.

Читателями спецификации являются люди. Спецификация считается хорошей, если по итогам её прочтения читатель понимает, как работает специфицированная страница.

Для работы над спецификацией предлагается простая последовательность действий:

1. Решаемая задача обсуждается командой фронтенда и бэкенда, проясняются спорные вопросы и набрасывается верхнеуровневое решение.
2. Это решение фиксируется одной из сторон, в виде пулреквеста в спецификацию. Вторая сторона проводит ревью.
3. Спецификация фиксируется, либо возвращаемся к шагу 1

> **NB** Этот же алгоритм применим и для внесения изменений в существующую спецификацию.
>
> Изменение спецификации взаимодействия должно обязательно сопровождаться задачей на фронт и бэк. Кроме того стоит написать в PR, зачем требуется изменение протокола и какой предлагается план миграции.

### Формат описания

По каждой ручке мы ожидаем получить следующий набор файлов:

-   **README.md** - описывает назначение ручки, важные ее особенности - см. цели спецификации.
-   **models.ts** - описывает модели данных, которые будут переданы в ручке.
-   **request.ts** - описывает формат запроса в терминах описанных моделей
-   **response.ts** - описывает формат ответа в терминах описанных моделей
-   \***\*mocks**/response200.ts\*\* - пример успешного ответа
-   \***\*mocks**/response404.ts\*\* - пример ошибочного ответа

Набор моков может отличаться в зависимости от задачи.

### Преимущества

1. На старте проекта/фичи прорабатываются явные проблемы, находятся подводные камни.
2. Команды фронтенда и бэкенда разговаривают в одинаковых терминах.
3. Разработка далее может идти параллельно.
4. Любые проблемы, найденные в процессе разработки, решаются на уровне спецификации, разработка не останавливается.
5. Спецификация является источником истины, по ней можно легко провалидивароть готовое решение.

## Части системы

-   Фронтенд путешествий, сокращенно фронтенд, ([репозиторий](https://github.yandex-team.ru/travel-ui/ya-travel))
-   API путешествий, сокращенно бэкенд, ([репозиторий](https://a.yandex-team.ru/arc/trunk/arcadia/travel/api))

## Содержание

-   [Страница отеля](/hotels/hotel-page-flow)
-   [Страница поиск отелей в регионе](/hotels/search-flow)
-   [Бронирование отеля](/hotels/booking-flow)
-   [Бронирование на Яндексе (generic)](/travel/orders/generic-booking-flow)
-   [Общие заголовки](/hotels/common/headers.md)
-   [Идентификаторы отеля](/hotels/common/hotel-identifiers.md)

## TODO

-   Сделать инструмент валидации `.json`-а по `.ts`.
    -   Предположительно, нужно скрестить [vega/ts-json-schema-generator](https://github.com/vega/ts-json-schema-generator)
        и [epoberezkin/ajv](https://github.com/epoberezkin/ajv). Первый делает из TypeScript-типов JSON-схему,
        а второй валидирует по JSON-схеме JSON-файл.
