import {IPrice} from '../../common/common';

export interface IVariant {
    forward_flights: IFlight[];
    backward_flights?: IFlight[];
}

export interface IFlight {
    from_station_id: number;
    to_station_id: number;
    local_departure_datetime: string;
    company_code: string;
    number: string;
}

export enum EServiceClass {
    ECONOMY = 'economy',
    BUSINESS = 'business',
}

export interface ITariff {
    price: IPrice;

    /**
       Сконвертированная по курсу цена, в случае если валюта исходой цены отличается от цены текущей нацверсии
     */
    exchanged_price?: IPrice;
}
