import {IPassengers} from 'avia/common/models';

import {ITariff, IVariant, EServiceClass} from './models';

export interface IRequest {
    /**
     * email-адрес пользователя.
     */
    email: string;

    /**
     * Travel-вертикаль (в данном случае всегда avia).
     */
    travel_vertical_name: string;

    /**
     * Код страницы, с которой подписывается пользователь.
     */
    source: string;

    /**
     * Таймзона пользователя.
     */
    timezone: string;

    /**
     * Slug-идентификатор национальной версии.
     */
    nationalVersion: string;
    /**
     * Slug-идентификатор языка.
     */
    language: string;

    /**
     * Вариант, на который подписывается пользователь
     */
    variant: IVariant;

    from_point_key: string;
    to_point_key: string;
    date_forward: string;
    date_backward?: string;
    passengers: IPassengers;
    service_class: EServiceClass;

    /**
     Багажность варианта, на который подписывается пользователь
     */
    with_baggage: boolean;

    tariff_without_baggage?: ITariff;
    tariff_with_baggage?: ITariff;
}
