import {EAviaLoyaltyCardType} from 'avia/common/models';
import {IPrice} from 'common/common';
import {
    IAviaOrderReservationSegmentFlightFareTerm,
    IAviaOrderReservationSegmentFlightStop,
} from 'travel/orders/getOrderHappyPage/models/models';

export interface IFlightDTO {
    id: string;
    from: number;
    to: number;
    stops: IAviaOrderReservationSegmentFlightStop[] | null;
    number: string | null;
    arrival: string;
    departure: string;
    marketingAviaCompany: number;
    operatingAviaCompany: number;
    fareTerms: IAviaOrderReservationSegmentFlightFareTerm;
}

export type TFareFamilyParameter =
    | 'description'
    | 'meal'
    | 'baggage'
    | 'carry_on'
    | 'refundable'
    | 'exchangeable'
    | 'seats_registration'
    | 'miles'
    | 'vip_service';

export type TParameterAvailability =
    | 'free'
    | 'not_available'
    | 'charge'
    | 'display';

export interface IFareFamilyParameterDTO {
    type: TFareFamilyParameter;
    shortDescription: string;
    fullDescription: string;
    fullDescriptionOrig: string;
    availability: TParameterAvailability;
}

export interface IFareFamilyInfoDTO {
    description: string;
    options: IFareFamilyParameterDTO[];
}

export interface ISegmentDTO {
    flights: IFlightDTO[];
    fareFamilyInfo?: IFareFamilyInfoDTO;
}

export interface IPromo2020Campaign {
    eligible?: boolean;
}

export interface IYandexPlusPromoCampaign {
    enabled: boolean;
    totalPlusPoints: number;
}

export type TBookingPromoCampaigns = {
    promo2020?: IPromo2020Campaign;
    plusPromo2021?: IYandexPlusPromoCampaign;
};

export interface IBookingFareInfo {
    flightId: string;
    fareBasis: string;
    fareFamilyCode: string;
}

export interface ICategoryPriceDTO {
    fare: IPrice;
    taxes: IPrice;
    total: IPrice;
    fareInfo: IBookingFareInfo[];
    quantity: number;
    passengerCategory: string;
}

export interface IVariantPriceInfoDTO {
    id: string;
    total: IPrice;
    agencyMarkup: IPrice | null;
    categoryPrices: ICategoryPriceDTO[];
}

export interface IBookingAllVariant {
    id: string;
    legs: ISegmentDTO[];
    promoCampaigns?: TBookingPromoCampaigns;
    variantPriceInfo: IVariantPriceInfoDTO;
    allowedLoyaltyPrograms: EAviaLoyaltyCardType[];
}
