/* eslint-disable camelcase */
import {IPrice} from 'common/common';
import {IReferenceDTO} from 'avia/common/IReferenceDTO';
import {IBookingDateTime, IPassengers} from 'avia/common/models';

import {IBookingAllVariant} from './IBookingAllVariant';

export {IBookingAllVariant};

export interface IBookingFlight {
    to: number;
    key: string;
    from: number;
    number: string;
    arrival: IBookingDateTime;
    company: number;
    departure: IBookingDateTime;
    aviaCompany: number;
    companyTariff: number;
}

export interface IBookingFlights {
    [key: string]: IBookingFlight;
}

export interface IBookingVariant {
    tag: string;
    route: string[][];
    expire: number;
    tariff: IPrice;
    baggage: string[][];
    charter: null | boolean;
    created: number;
}

export interface IBookingYauser {}

export interface IBookingDjangoUser {
    is_staff: boolean;
}

export interface IBookingUserInfo {
    userip: string;
    yauser: IBookingYauser;
    yandexuid: string;
    django_user: IBookingDjangoUser;
}

export interface IBookingOrderData {
    qid: string;
    url: string;
    lang: string;
    qkey: string;
    tariff: IPrice;
    partner: string;
    national_version: string;
}

export interface IBookingPriceInfo {
    first_check_price: IPrice;
    preliminary_price: IPrice;
}

export interface IBookingVariantInfo {
    variant: IBookingAllVariant;
    reference: IReferenceDTO;
}

export interface IBookingRedirectOrderData {
    url: string;
}

export interface IBookingRedirectData {
    order_data: IBookingRedirectOrderData;
    query_source: string;
}
export interface IBookingDirectionData {
    number: string;
    departure_datetime: number;
}

/** TODO: Уточнить у tlg-13 не повторяет ли это общий IPrice */
export interface IBookingShownTariff {
    value: string;
    currency: string;
}

export interface IBookingAdditionalData {
    qid: string;
    lang: string;
    klass: string;
    marker: string;
    forward: IBookingDirectionData[];
    partner: string;
    service: string;
    backward: IBookingDirectionData[] | null;
    point_to: any[];
    user_info: IBookingUserInfo;
    passengers: IPassengers;
    point_from: any[];
    utm_medium: string;
    utm_source: string;
    tariff_sign: string;
    utm_content: string;
    date_forward: number;
    shown_tariff: IBookingShownTariff;
    utm_campaign: string;
    with_baggage: boolean;
    date_backward?: any;
    book_on_yandex: boolean;
    national_version: string;
}
