import {IPrice, TUuid} from 'common/common';

import {IReferenceDTO} from './IReferenceDTO';
import {
    IAirReservationDTO,
    ITravellerInfoDTO,
    TOrderState,
    IBookingDateTime,
    TOrderError,
} from './models';
import {EDisplayOrderState} from '../../travel/orders/getOrderHappyPage/models/models';

// TODO: у нас есть IGenericOrderInfo, стоит рассмотреть возможность унифицировать эти типы
export interface IOrderDTO {
    id: TUuid;
    prettyId: string;
    partner: string;
    orderRefNum: string;
    email: string;
    phone: string;
    airReservation: IAirReservationDTO;
    travellers: ITravellerInfoDTO[];
    preliminaryPrice: IPrice;
    price: IPrice;
    agencyMarkup: IPrice;
    paymentCanBeInitialized: boolean;
    state: TOrderState;
    edisplayOrderState: EDisplayOrderState;
    timeLimitAt: IBookingDateTime;
    fareRulesUrl: string;
    errorCode: TOrderError;
    reference: IReferenceDTO;

    /**
     * id поездки, к которой привязан заказ. Если поездки еще нет, то отсутствует
     */
    tripId?: TUuid | null;
}
