export interface IAirlineReferenceDTO {
    alliance: string | null;
    title: string;
    url: string;
    logoSvg: string;
    color: string;
    sirenaCode: string;
    iataCode: string;
    id: number;
}

export interface IAirportReferenceDTO {
    settlement: number;
    code: string;
    phraseFrom: string;
    title: string;
    ttype: string;
    phraseIn: string;
    phraseTo: string;
    id: number;
    timeZoneCode: string;
    timeZoneOffset: number;
}

export interface ISettlementReferenceDTO {
    id: number;
    countryId: number;
    title: string;
    phraseFrom: string;
    phraseIn: string;
    phraseTo: string;
}

export interface IPartnerInfoDTO {
    code: string;
    title: string;
    phones: string[];
    logoUrl: string;
    email: string;
}

export interface IReferenceDTO {
    airlines: IAirlineReferenceDTO[];
    airports: IAirportReferenceDTO[];
    settlements: ISettlementReferenceDTO[];
    partnerInfo: IPartnerInfoDTO;
}
