import {EGender, IPrice} from 'common/common';

export interface IPassengers {
    adults: number;
    children: number;
    infants: number;
}

export interface IBookingDateTime {
    local: string;
    offset: number;
    tzname: string;
}

/**
 * Класс обслуживания
 */
export enum EKlass {
    BUSINESS = 'business',
    ECONOMY = 'economy',
}

export enum EAviaLoyaltyCardType {
    AVIA_SU = 'avia_su',
    AVIA_AR = 'avia_ar',
    AVIA_AM = 'avia_am',
    AVIA_UX = 'avia_ux',
    AVIA_AF = 'avia_af',
    AVIA_AZ = 'avia_az',
    AVIA_CI = 'avia_ci',
    AVIA_MU = 'avia_mu',
    AVIA_CZ = 'avia_cz',
    AVIA_OK = 'avia_ok',
    AVIA_DL = 'avia_dl',
    AVIA_GA = 'avia_ga',
    AVIA_KQ = 'avia_kq',
    AVIA_KL = 'avia_kl',
    AVIA_KE = 'avia_ke',
    AVIA_ME = 'avia_me',
    AVIA_AE = 'avia_ae',
    AVIA_SV = 'avia_sv',
    AVIA_FM = 'avia_fm',
    AVIA_RO = 'avia_ro',
    AVIA_VN = 'avia_vn',
    AVIA_MF = 'avia_mf',
}

export enum EAviaDocumentType {
    PASSPORT = 'passport',
    INTERNATIONAL_PASSPORT_RU = 'international_passport_ru',
    BIRTH_CERTIFICATE = 'birth_certificate',
    NATIONAL_PASSPORT = 'national_passport',
}

export enum EPassengerCategory {
    ADULT = 'adult',
    CHILD = 'child',
    INFANT = 'infant',
}

export type TParameterAvailability =
    | 'free'
    | 'not_available'
    | 'charge'
    | 'display';

export type TFareFamilyParameter =
    | 'description'
    | 'meal'
    | 'baggage'
    | 'carry_on'
    | 'refundable'
    | 'exchangeable'
    | 'seats_registration'
    | 'miles'
    | 'vip_service';

export enum EClassOfService {
    ECONOMY = 'economy',
    BUSINESS = 'business',
    FIRST = 'first',
    PREMIUM_ECONOMY = 'premium_economy',
    OTHER = 'other',
}

export enum ETermAvailability {
    FREE = 'FREE',
    CHARGE = 'CHARGE',
    NOT_AVAILABLE = 'NOT_AVAILABLE',
}

export type TOrderState =
    | 'new'
    | 'booking'
    | 'booked'
    | 'cancelling'
    | 'cancelled'
    | 'processing_error'
    | 'ticketing'
    | 'ticketed'
    | 'deferred_ticketing';

export type TOrderError =
    | 'variants_not_available'
    | 'max_time_in_queue'
    | 'price_changed'
    | 'unhandled';

export interface IAirReservationDTO {
    pnr: string;
    partnerRef: string;
    segments: ISegmentDTO[];
    originalPnr: string;
}

export interface ISegmentDTO {
    flights: IFlightDTO[];
    fareFamilyInfo: IFareFamilyInfoDTO;
}

export interface IFareFamilyInfoDTO {
    description: string;
    options: IFareFamilyParameterDTO[];
}

export interface IFareFamilyParameterDTO {
    type: TFareFamilyParameter;
    shortDescription: string;
    fullDescription: string;
    fullDescriptionOrig: string;
    availability: TParameterAvailability;
}

export interface IFlightDTO {
    id: string;
    to: number;
    from: number;
    stops: IFlightStopDTO[] | null;
    number: string | null;
    arrival: string;
    departure: string;
    marketingAviaCompany: number;
    operatingAviaCompany: number;
    fareTerms: ISegmentFare;
}

export interface ISegmentFare {
    baseClass: EClassOfService;
    tariffGroupName: string;
    terms: Record<string, ITermValue>;
}

export interface ITermValue {
    availability: ETermAvailability;
    charge: IPrice;
    miles: string;

    /**
     * baggage-related
     */
    places: number;
    weight?: number;
    size?: string;

    specialNotes: string[];
}

export interface IFlightStopDTO {
    airportId: number;
    terminal: string;
}

export interface ITravellerInfoDTO {
    id: string;
    firstName: string | null;
    middleName: string | null;
    lastName: string | null;
    sex: EGender;
    category: EPassengerCategory;
    dateOfBirth: string;
    documentNumber: string;
    documentValidTill: string;
    documentType: EAviaDocumentType;
    priceInfo: ITravellerPriceInfoDTO;
    ticketNumber: string;
}

export interface ITravellerPriceInfoDTO {
    fare: IPrice;
    tax: IPrice;
    total: IPrice;
}

export interface IPartnerInfoDTO {
    code: string;
    title: string;
    phones: string[];
    logoUrl: string;
    email: string;
}

export interface ISettlementReferenceDTO {
    id: number;
    countryId: number;
    title: string;
    phraseFrom: string;
    phraseIn: string;
    phraseTo: string;
}

export interface IAirlineReferenceDTO {
    alliance: string | null;
    title: string;
    url: string;
    logoSvg: string;
    color: string;
    sirenaCode: string;
    iataCode: string;
    id: number;
}
