import {IGetCountryRestrictionsResponse} from '../response';
import {ERichStringBlockType} from '../../../../common/RichString';

const countryRestrictionsResponse: IGetCountryRestrictionsResponse = {
    destination: {
        metrics: {
            flightsAvailability: {
                value: true,
                text: {
                    data: [
                        {
                            blockType: 'text' as ERichStringBlockType.TEXT,
                            data: {
                                text: 'Присутствует',
                            },
                        },
                    ],
                },
                additions: [],
                exclusions: [],
                updatedTime: '2021-12-23T08:26:41.288882+00:00',
                lastModificationTime: '2021-12-23T08:26:41.288882+00:00',
                pointInfo: {
                    pointKey: 'l84',
                    geoId: 84,
                    type: 4,
                    title: {
                        nominativeCase: 'США',
                        genitiveCase: 'США',
                        dativeCase: 'США',
                        prepositionalCase: 'США',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'США',
                        instrumentalCase: 'США',
                    },
                },
            },
            tourismAvailability: {
                value: true,
                text: {
                    data: [
                        {
                            blockType: 'text' as ERichStringBlockType.TEXT,
                            data: {
                                text: 'Разрешен',
                            },
                        },
                    ],
                },
                additions: [],
                exclusions: [],
                updatedTime: '2021-12-23T08:26:41.288882+00:00',
                lastModificationTime: '2021-12-23T08:26:41.288882+00:00',
                pointInfo: {
                    pointKey: 'l84',
                    geoId: 84,
                    type: 4,
                    title: {
                        nominativeCase: 'США',
                        genitiveCase: 'США',
                        dativeCase: 'США',
                        prepositionalCase: 'США',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'США',
                        instrumentalCase: 'США',
                    },
                },
            },
            quarantineRequired: {
                value: false,
                text: {
                    data: [
                        {
                            blockType: 'text' as ERichStringBlockType.TEXT,
                            data: {
                                text: 'Не требуется',
                            },
                        },
                    ],
                },
                additions: [],
                exclusions: [],
                updatedTime: '2021-12-23T08:26:41.288882+00:00',
                lastModificationTime: '2021-12-23T08:26:41.288882+00:00',
                pointInfo: {
                    pointKey: 'l84',
                    geoId: 84,
                    type: 4,
                    title: {
                        nominativeCase: 'США',
                        genitiveCase: 'США',
                        dativeCase: 'США',
                        prepositionalCase: 'США',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'США',
                        instrumentalCase: 'США',
                    },
                },
            },
            visaRequired: {
                value: true,
                text: {
                    data: [
                        {
                            blockType: 'text' as ERichStringBlockType.TEXT,
                            data: {
                                text: 'Требуется',
                            },
                        },
                    ],
                },
                additions: [],
                exclusions: [],
                updatedTime: '2021-12-23T08:26:41.288882+00:00',
                lastModificationTime: '2021-12-23T08:26:41.288882+00:00',
                pointInfo: {
                    pointKey: 'l84',
                    geoId: 84,
                    type: 4,
                    title: {
                        nominativeCase: 'США',
                        genitiveCase: 'США',
                        dativeCase: 'США',
                        prepositionalCase: 'США',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'США',
                        instrumentalCase: 'США',
                    },
                },
            },
            pcrExpirationPeriodInHoursOrRequired: {
                value: 72,
                text: {
                    data: [
                        {
                            blockType: 'text' as ERichStringBlockType.TEXT,
                            data: {
                                text: '72 часа',
                            },
                        },
                    ],
                },
                additions: [],
                exclusions: [
                    {
                        data: [
                            {
                                blockType: 'text' as ERichStringBlockType.TEXT,
                                data: {
                                    text: 'Не нужен для детей до 1 года',
                                },
                            },
                        ],
                    },
                ],
                updatedTime: '2021-11-28T16:40:34.078410+00:00',
                lastModificationTime: '2021-12-23T08:26:41.288882+00:00',
                pointInfo: {
                    pointKey: 'l84',
                    geoId: 84,
                    type: 4,
                    title: {
                        nominativeCase: 'США',
                        genitiveCase: 'США',
                        dativeCase: 'США',
                        prepositionalCase: 'США',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'США',
                        instrumentalCase: 'США',
                    },
                },
            },
            approvedVaccines: {
                value: ['Moderna', 'Pfizer'],
                text: {
                    data: [
                        {
                            blockType: 'text' as ERichStringBlockType.TEXT,
                            data: {
                                text: 'Разрешенные вакцины: Moderna, Pfizer',
                            },
                        },
                    ],
                },
                additions: [],
                exclusions: [],
                updatedTime: '2021-11-28T16:40:34.078410+00:00',
                lastModificationTime: '2021-12-23T08:26:41.288882+00:00',
                pointInfo: {
                    pointKey: 'l84',
                    geoId: 84,
                    type: 4,
                    title: {
                        nominativeCase: 'США',
                        genitiveCase: 'США',
                        dativeCase: 'США',
                        prepositionalCase: 'США',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'США',
                        instrumentalCase: 'США',
                    },
                },
            },
            formsToFill: {
                value: [
                    'https://www.cdc.gov/quarantine/pdf/combined-passenger-attestation-p.pdf',
                ],
                text: {
                    data: [
                        {
                            blockType: 'text' as ERichStringBlockType.TEXT,
                            data: {
                                text: 'Необходимо заполнить форму',
                            },
                        },
                        {
                            blockType: 'url' as ERichStringBlockType.URL,
                            data: {
                                text: 'по ссылке',
                                url: 'https://www.cdc.gov/quarantine/pdf/combined-passenger-attestation-p.pdf',
                            },
                        },
                    ],
                },
                additions: [],
                exclusions: [],
                updatedTime: '2021-11-28T16:40:34.078410+00:00',
                lastModificationTime: '2021-12-23T08:26:41.288882+00:00',
                pointInfo: {
                    pointKey: 'l84',
                    geoId: 84,
                    type: 4,
                    title: {
                        nominativeCase: 'США',
                        genitiveCase: 'США',
                        dativeCase: 'США',
                        prepositionalCase: 'США',
                        preposition: 'в',
                        locativeCase: '',
                        directionalCase: '',
                        ablativeCase: '',
                        accusativeCase: 'США',
                        instrumentalCase: 'США',
                    },
                },
            },
        },
    },
};

export default countryRestrictionsResponse;
