import {ILinguistics, TDate, TInstantDateTime} from '../../../common/common';
import {TGeoId} from '../../../common/TGeoId';
import {TPointKey} from '../../../common/PointKey';
import {IRichString} from '../../../common/RichString';

export enum EPointType {
    UNKNOWN = 0,
    STATION = 1,
    SETTLEMENT = 2,
    REGION = 3,
    COUNTRY = 4,
}

export interface IPointInfo {
    geoId: TGeoId | null;
    pointKey: TPointKey;
    title: ILinguistics;
    type: EPointType;
}

export interface ICommonMetric {
    text: IRichString;
    additions: IRichString[]; // пример: ['Результат ПЦР должен быть на бумажном носителе']
    exclusions: IRichString[]; // пример: ['Не нужен для детей']
    updatedTime: TInstantDateTime;
    lastModificationTime: TInstantDateTime;
    pointInfo: IPointInfo;
}

export interface ICustomTypeMetric<CustomType> extends ICommonMetric {
    value: CustomType;
}

export interface IStringMetric extends ICommonMetric {
    value: string;
}

export interface IBooleanMetric extends ICommonMetric {
    value: boolean;
}

export interface INumberOrBooleanMetric extends ICommonMetric {
    value: number | boolean;
}

export interface IStringListMetric extends ICommonMetric {
    value: string[];
}

export interface IDateMetric extends ICommonMetric {
    value: TDate;
}

export enum EFlightsAvailabilityV2 {
    DIRECT_FLIGHTS = 'directFlights',
    TRANSFER_FLIGHTS = 'transferFlights',
    NO_FLIGHTS = 'noFlights',
}

export enum EEntranceForRussians {
    FREE_ENTRANCE = 'freeEntrance',
    HAS_RESTRICTIONS = 'hasRestrictions',
    NO_ENTRANCE = 'noEntrance',
}

export interface IBankCardPayments {
    russianVisaMastercard?: boolean;
    mir?: boolean;
    unionPay?: boolean;
}

export interface IPointRestrictions {
    flightsAvailability?: IBooleanMetric;
    tourismAvailability?: IBooleanMetric;
    tourismAvailableFrom?: IDateMetric;
    quarantineRequired?: INumberOrBooleanMetric;
    visaRequired?: IBooleanMetric;
    covidInsuranceRequired?: IBooleanMetric;
    mobileAppRequired?: IBooleanMetric;
    pcrExpirationPeriodInHoursOrRequired?: INumberOrBooleanMetric;
    approvedVaccines?: IStringListMetric;
    isSputnikApproved?: IBooleanMetric;
    formsToFill?: IStringListMetric;
    flightsAvailabilityV2?: ICustomTypeMetric<EFlightsAvailabilityV2>;
    entranceForRussians?: ICustomTypeMetric<EEntranceForRussians>;
    bankCardPayments?: ICustomTypeMetric<IBankCardPayments>;
}

export interface IDestinationInformation {
    metrics: IPointRestrictions;
}
