import {ICommonMetric, IDestinationInformation} from './models';
import {IRichString} from '../../../common/RichString';

export interface IGetCountryRestrictionsResponse {
    destination: IDestinationInformation;
}

enum EColor {
    GRAY = 'gray',
    GREEN = 'green',
    RED = 'red',
}

export enum EIcons {
    PLANE = 'Plane',
    SHILD = 'Shild',
    CARD = 'Card',
    QUESTIONNAIRE = 'Questionnaire',
    QUARANTINE = 'Quarantine',
    DISCOVERY = 'Discovery',
    WARNING_FILLED = 'WarningFilled',
    COVID_SHILD = 'CovidShild',
    GLOBE = 'Globe',
}

export interface IGetCountryRestrictionsExtendedMetric {
    title: IRichString;
    icon24: EIcons;
    metricName: string;
    metricValue?: ICommonMetric; // if null/undefined, there should be only icon and title
}

export interface IGetExtendedCountryRestrictionsResponse {
    color: EColor;
    titleText: string; // upper part of minimized banner
    desktopMinimized: string[]; // desktop lower part of minimized banner
    mobileMinimized: string[]; // mobile lower part of minimized banner
    expandedBannerMetrics: IGetCountryRestrictionsExtendedMetric[];
}
