import {ETernaryChoice, TInstantDateTime} from '../../common/common';

// описание - https://st.yandex-team.ru/TRAVELFRONT-5444
export interface IResponseSuccess {
    status: 'ok';
    data: {
        country_id: number;
        country_title_ru: string;
        tourism: ETernaryChoice;
        quarantine: ETernaryChoice;
        quarantine_days: number;
        visa: ETernaryChoice;
        avia: ETernaryChoice;

        /** Передаются при параметре debug=true */
        /** Время последнего обновления. */
        updated_at?: TInstantDateTime;
        /** Комментарий из таблицы */
        comment?: string;
    };
}
export interface IResponseError {
    status: 'error';
}

export type TResponse = IResponseSuccess | IResponseError;
