import {IResponse} from '../response';
import {EAviaClass, ESuggestType} from '../models';

const response200: IResponse = {
    suggests: [
        {
            from: {
                type: ESuggestType.CITY,
                title: 'Москва',
                pointCode: 'MOW',
                pointKey: 'c213',
                countryTitle: 'Россия',
                cityTitle: 'Москва',
                regionTitle: 'Москва и Московская область',
            },
            to: {
                type: ESuggestType.CITY,
                title: 'Санкт-Петербург',
                pointCode: 'LED',
                pointKey: 'c2',
                countryTitle: 'Россия',
                cityTitle: 'Санкт-Петербург',
                regionTitle: 'Санкт-Петербург и Ленинградская область',
            },
            startDate: '2021-06-04',
            endDate: '2021-06-08',
            travelers: {
                adults: 2,
                children: 1,
                infants: 0,
            },
            aviaClass: EAviaClass.ECONOMY,
        },
        {
            from: {
                type: ESuggestType.AIRPORT,
                title: 'Шереметьево',
                pointCode: 'SVO',
                pointKey: 's9600213',
                countryTitle: 'Россия',
                cityTitle: 'Москва',
                regionTitle: 'Москва и Московская область',
            },
            to: {
                type: ESuggestType.CITY,
                title: 'Париж',
                pointCode: 'PAR',
                pointKey: 'c10502',
                countryTitle: 'Франция',
                cityTitle: 'Париж',
                regionTitle: 'Иль-де-Франс',
            },
            startDate: null,
            endDate: null,
            travelers: {
                adults: 1,
                children: 0,
                infants: 1,
            },
            aviaClass: EAviaClass.BUSINESS,
        },
    ],
};

export default response200;
