import {IPassengers} from 'avia/common/models';

export enum ESuggestType {
    CITY = 0,
    AIRPORT = 1,
    COUNTRY = 2,
}

export enum EAviaClass {
    ECONOMY = 'economy',
    BUSINESS = 'business',
}

export interface ISuggest {
    type: ESuggestType;
    title: string;
    pointCode: string;
    pointKey: string;
    countryTitle: string;
    cityTitle: string;
    regionTitle: string;
}

export interface IHistorySearchSuggest {
    from: ISuggest;
    to: ISuggest;
    startDate: string | null; // null, если дата в прошлом
    endDate: string | null; // null, если startDate в прошлом или нет endDate
    travelers: IPassengers;
    aviaClass: EAviaClass;
}
