/* eslint-disable camelcase */
import {ECarryOnType} from '.';

export type TTariffGroupNameLang = 'ru' | 'en';

export type TFareFamilyKey = string;

export type TVariantFareFamilyKey = null | TFareFamilyKey;

export type TVariantFareFamilyKeysByDirection = TVariantFareFamilyKey[];

export type TVariantFareFamilyKeys = [
    TVariantFareFamilyKeysByDirection,
    TVariantFareFamilyKeysByDirection,
];

export enum EFareFamilyTermCode {
    /** багаж */
    BAGGAGE = 'baggage',
    /** мили */
    MILES = 'miles',
    /** возврат */
    REFUNDALE = 'refundable',
    /** обмен */
    CHANGING_CARRIAGE = 'changing_carriage',
    /** габариты */
    CARRY_ON = 'carry_on',
    /** ссылка на тарифы авиакомпании */
    DISCLOSURE_URL = 'disclosure_url',
    /** выбор места */
    SEAT_SELECTION_CHECK_IN = 'seat_selection_check_in',

    // эти не показываем
    REFUNDABLE_NO_SHOW = 'refundable_no_show',
    CHANGING_CARRIAGE_NO_SHOW = 'changing_carriage_no_show',
    OPEN_RETURN_DATE = 'open_return_date',
}

export enum EFareFamilyAvailability {
    NOT_AVAILABLE = 'NOT_AVAILABLE',
    CHARGE = 'CHARGE',
    FREE = 'FREE',
}

export interface IFFRefundableTermRule {
    availability: EFareFamilyAvailability;
    charge?: Partial<{
        currency: string;
        value: string;
    }>;
}

// baggage
export interface IFFBaggageTerm {
    code: EFareFamilyTermCode.BAGGAGE;
    rule: IFFBaggageTermRule;
}

export interface IFFBaggageTermRule {
    places: number;
    weight?: number;
    size?: string;
}

// miles
export interface IFFMilesTerm {
    code: EFareFamilyTermCode.MILES;
    rule: IFFMilesTermRule;
}

export interface IFFMilesTermRule {
    miles: string;
}

export interface IFFRefundableTerm {
    code: EFareFamilyTermCode.REFUNDALE;
    rule: IFFRefundableTermRule;
}

// changing_carriage
export interface IFFChangingCarriageTerm {
    code: EFareFamilyTermCode.CHANGING_CARRIAGE;
    rule: IFFChangingCarriageTermRule;
}

export interface IFFChangingCarriageTermRule {
    availability: EFareFamilyAvailability;
    charge?: {
        currency: string;
        value: string;
    };
}

// carry_on
export interface IFFCarryOnTerm {
    code: EFareFamilyTermCode.CARRY_ON;
    rule: IFFCarryOnTermRule;
}

export interface IFFCarryOnTermRule {
    /** Признак сокращенной ручной клади */
    carry_on_size_bucket: ECarryOnType;
    comment?: string;
    weight: number;
    places: number;
    size: string;
}

// refundable_no_show
export interface IFFRefundableNoShowTerm {
    code: EFareFamilyTermCode.REFUNDABLE_NO_SHOW;
}

// changing_carriage_no_show
export interface IFFChangingCarriageNoShowTerm {
    code: EFareFamilyTermCode.CHANGING_CARRIAGE_NO_SHOW;
}

// open_return_date
export interface IFFOpenReturnDateTerm {
    code: EFareFamilyTermCode.OPEN_RETURN_DATE;
}

// disclosure_url
export interface IFFDisclosureUrlTermRule {
    special_notes: [
        {
            ru: string;
        },
    ];
}

export interface IFFDisclosureUrlTerm {
    code: EFareFamilyTermCode.DISCLOSURE_URL;
    rule: IFFDisclosureUrlTermRule;
}

// seat_selection_check_in
export interface IFFSeatSelectionCheckInTermRule {
    availability: EFareFamilyAvailability;
    charge?: {
        currency: string;
        value: string;
    };
}

export interface IFFSeatSelectionCheckInTerm {
    code: EFareFamilyTermCode.SEAT_SELECTION_CHECK_IN;
    rule: IFFSeatSelectionCheckInTermRule;
}

export type TTerm =
    | IFFBaggageTerm
    | IFFMilesTerm
    | IFFRefundableTerm
    | IFFChangingCarriageTerm
    | IFFCarryOnTerm
    | IFFRefundableNoShowTerm
    | IFFChangingCarriageNoShowTerm
    | IFFOpenReturnDateTerm
    | IFFDisclosureUrlTerm
    | IFFSeatSelectionCheckInTerm;

interface IFareFamily {
    terms: TTerm[];
    tariff_group_name: Record<TTariffGroupNameLang, string>;
}

export type TFareFamilies = Record<TFareFamilyKey, IFareFamily>;
