import {IPrice} from '../../../common/common';
import {TFareFamilies, TVariantFareFamilyKeys} from './fareFamily';

/*
 * Есть источник данных тут https://a.yandex-team.ru/arc/trunk/arcadia/travel/avia/ticket_daemon_api/data/fare_families
 * но от TD эти данные приходят в трансформированном виде
 */

export type TCostType = 'normal' | 'lowcost' | 'hybrid';

export type TFlightKey = string;

export type TRoute = TFlightKey[];

export type TBaggageKey = string;

export type TFlightNumber = string;

export interface IProgress {
    all: number;
    current: number;
}

export interface IAlliance {
    id: number;
    title: string;
}

/**
 * Признак сокращенной ручной клади
 * @description Сокращенная ручная кладь - нет ни одного измерения больше 49
 * @example
 *  Ютейр 40х30х20 5
 *  Смартавиа 40х30х20 10
 *  Победа 36х30х27
 */
export enum ECarryOnType {
    /** сокращенная ручная кладь */
    SMALL = 'small',
    /** стандартная ручная кладь */
    REGULAR = 'regular',
}

export interface IAviaCompany {
    id: number;
    /** Признак сокращенной ручной клади */
    carryonSizeBucket: ECarryOnType;
    baggageDimensionsSum?: number;
    baggageRules?: string;
    baggageRulesUrl?: string;
    carryonHeight?: number;
    carryonLength?: number;
    carryonWidth?: number;
    costType: TCostType;
}

export interface IBaggageOption {
    count?: number | null;
    /** Откуда получена информация о багаже: от партнёра или из базы */
    source: 'partner' | 'db' | 'fare_families' | null;
    [key: string]: number | undefined | string | null;
}

export interface IBaggageTDTariff {
    included?: IBaggageOption;
    /** Количество сумок */
    pc?: IBaggageOption;
    /** Вес сумки в кг */
    wt?: IBaggageOption;
    [key: string]: IBaggageOption | undefined;
}

export interface ICompany {
    id: number;
    logoSvg: string;
    title: string;
    url: string;
    alliance: number | null;
    color?: string;
}

export interface ICompanyTariff {
    baggageAllowed: boolean;
    baggageNorm: number | null;
    carryon: boolean;
    carryonNorm: number | null;
    id: number;
    published: boolean;
}

export interface IFlightDate {
    local: string;
    tzname?: string;
    offset: number;
}

export interface IFlight {
    arrival: IFlightDate | null;
    aviaCompany?: number;
    company: number;
    companyTariff?: number;
    departure: IFlightDate | null;
    from: number;
    key: TFlightKey;
    number: TFlightNumber;
    tModel: string | null;
    to: number;
}

export interface ITDPartner {
    id: number;
    code: string;
    siteUrl?: string;
    logoSvg?: string | null;
    title: string;
}

export interface IRating {
    canceled?: number;
    /** Вероятности задержки от 0 до 100 */
    delayed3060?: number;
    delayed6090?: number;
    delayedLess30?: number;
    delayedMore90?: number;
    number: TFlightNumber;
    scores?: number;
}

export interface ISettlement {
    countryId: number;
    id: number;
    phraseFrom?: string;
    phraseIn?: string;
    phraseTo?: string;
    preposition?: string;
    title: string;
}

export interface IStationType {
    prefix: string;
    title: string;
}

export type TStationType = 'plane' | 'bus' | 'train';

/** TODO: сильно похож на IAirportReferenceDTO, может они про одно и то же? */
export interface IStation {
    code: string;
    id: number;
    phraseFrom: string;
    phraseIn: string;
    phraseTo: string;
    preposition?: string;
    settlement: number;
    stationType: IStationType;
    /** Тип станции */
    tType: TStationType;
    title: string;
}

export interface IReference {
    alliances: IAlliance[];
    aviaCompanies: IAviaCompany[];
    baggageTariffs: Record<string, IBaggageTDTariff>;
    companies: ICompany[];
    companyTariffs: ICompanyTariff[];
    flights: IFlight[];
    partners: ITDPartner[];
    ratings: IRating[];
    reviewsCount: Record<string, number>;
    settlements: ISettlement[];
    stations: IStation[];
    fareFamilies: TFareFamilies;
}

export enum EAviaPromoType {
    WHITE_MONDAY = 'white-monday',
}

export interface IAviaPromo {
    /**
     * код промоакции
     */
    code: EAviaPromoType;
    /**
     * дата до которой действует акция
     */
    endActionDt: string;
    /**
     * таймзона относительно которой идёт отсчет времени акции
     */
    endActionTz: string;
}

enum EPriceCategory {
    UNKNOWN = 'unknown',
    GOOD = 'good',
    BAD = 'bad',
}

export interface IVariantPrice {
    baggage: TBaggageKey[][];
    partnerCode: string;
    /** Время ответа партнёра в секундах */
    queryTime: number;
    tariff: IPrice;
    /** Для логов */
    tariff_sign: string;
    /** Вариант продаёт авиакомпания */
    fromCompany?: boolean;
    promo?: IAviaPromo;
    charter?: boolean;
    service: string;
    fare_codes?: string[][][];
    fare_families?: TVariantFareFamilyKeys;
    boy: boolean;
    /** Одна или несколько пересадок - самостоятельная (на пути туда или обратно) */
    selfconnect?: boolean;
    /**
     * Тетя Роза - Оценка данного предложения на основе нашего анализа данных других/прошлых перелетов
     * Например: мы считаем что для этого перелета это хорошая/плохая цена
     */
    priceCategory?: EPriceCategory;
    /** Бонусы Яндекс.Плюса */
    plusPoints?: number;
}

export interface IFare {
    hybrid?: boolean;
    prices: IVariantPrice[];
    route: TRoute[];
}

export interface IVariants {
    fares: IFare[];
}

export type TStatus = 'done' | 'querying' | 'outdated';

export interface IAviaTDAnswer {
    cont: number | null;
    progress: IProgress;
    reference: IReference;
    variants: IVariants;
    partners?: Record<string, TStatus>;
    /** Идентификатор запроса */
    qid: string;
}
