import {ESectionBlock} from 'common/seo-pages/ISectionTextBlock';
import {ELandingBlockType} from 'avia/seo-pages/common/ELandingBlockType';

import {IResponse} from '../response';

export const responce200: IResponse = {
    seoInfo: {
        openGraph: {
            image: 'https://avatars.mds.yandex.net/get-avia/233213/2a0000015a80437fec5bb0af3293c5f3b4b9/orig',
            imageSize: {
                width: 1815,
                height: 1212,
            },
            description:
                'Авиабилеты в Москву по выгодным ценам. Поиск прямых рейсов и вариантов с пересадками, удобное сравнение предложений. Выбирайте и покупайте онлайн — билеты на самолет в Москву на Яндекс.Путешествиях.',
            title: 'Дешёвые авиабилеты в Москву на Яндекс.Путешествиях',
        },
        schemaOrg: {
            faqItems: [
                {
                    answer: 'В Москве 3 аэропорта — Шереметьево (SVO) Внуково (VKO) Домодедово (DME) ',
                    question: 'Сколько аэропортов в Москве?',
                },
                {
                    answer: 'Ближайший аэропорт — Шереметьево, от него до центра Москвы — 100 км. От Внуково — 100 км. От Домодедово — 100 км.',
                    question: 'Далеко аэропорт от города?',
                },
                {
                    answer: 'Подпишитесь на рассылку, и вы всегда будете в курсе цен. Заказывайте билеты заранее, используйте невозвратные тарифы, летайте без багажа.',
                    question: 'Как дешевле всего долететь до Москву?',
                },
                {
                    answer: 'Лучший рейтинг у следующих авиакомпаний: Аэрофлот, Уральские авиалинии, S7 Airlines. Так же в Москву летают: Победа, ЮТэйр, Россия, Nordwind и другие.',
                    question: 'Самолёты каких авиакомпаний летают в Москву?',
                },
            ],
        },
        description:
            'Авиабилеты в Москву по выгодным ценам. Поиск прямых рейсов и вариантов с пересадками, удобное сравнение предложений. Выбирайте и покупайте онлайн — билеты на самолет в Москву на Яндекс.Путешествиях.',
        title: 'Дешёвые авиабилеты в Москву на Яндекс.Путешествиях',
    },
    blocks: [
        {
            data: {
                items: [
                    {
                        link: 'https://travel.yandex.ru/avia/',
                        title: 'Авиабилеты',
                    },
                    {
                        title: 'Москва',
                    },
                ],
            },
            type: ELandingBlockType.BREAD_CRUMBS_BLOCK,
        },
        {
            data: {
                searchFormParams: {
                    toId: 'c213',
                    isCalendarOpen: true,
                },
                imageUrl:
                    'https://avatars.mds.yandex.net/get-avia/233213/2a0000015a80437fec5bb0af3293c5f3b4b9/orig',
                title: 'Дешёвые авиабилеты в Москву',
            },
            type: ELandingBlockType.SEARCH_FORM_BLOCK,
        },
        {
            data: {
                toId: 'c213',
                navigationTitle: 'Динамика цен на билеты',
                when: '2021-07-11',
                description:
                    'Если вам не принципиальна дата отправления, посмотрите динамику цен в календаре: билеты на соседние дни могут стоить дешевле. Здесь вы подберёте подходящий рейс туда и обратно по времени отправления и прибытия, длительности поездки, наличию багажа и другим критериям.',
                title: 'Цены на авиабилеты в Москву в разные даты',
            },
            type: ELandingBlockType.DYNAMICS_BLOCK,
        },
        {
            data: {
                navigationTitle: 'Когда лучше лететь',
                title: 'Когда выгоднее лететь в Москву',
            },
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            children: [
                {
                    type: ESectionBlock.TEXT_BLOCK,
                    children: [
                        {
                            data: {
                                text: 'Если хотите сэкономить, то летайте в ноябре — цена получится ниже средней годовой на 24 %.',
                            },
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                        },
                    ],
                },
                {
                    type: ESectionBlock.TEXT_BLOCK,
                    children: [
                        {
                            data: {
                                text: 'А вот в марте — самые дорогие билеты.',
                            },
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                        },
                    ],
                },
            ],
        },
        {
            data: {
                text: 'Ниже минимальные цены на рейсы за последние 30 дней. Стоимость авиабилета может меняться в зависимости от распродаж, даты полета и наличия билетов.',
                navigationTitle: 'Популярные рейсы',
                title: 'Популярные рейсы в Москву из других городов',
            },
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            children: [],
        },
        {
            data: {
                items: [
                    {
                        fromSlug: 'moscow',
                        name: 'Москва',
                    },
                    {
                        fromSlug: 'saint-petersburg',
                        name: 'Санкт-Петербург',
                    },
                    {
                        fromSlug: 'yekaterinburg',
                        name: 'Екатеринбург',
                    },
                    {
                        fromSlug: 'novosibirsk',
                        name: 'Новосибирск',
                    },
                    {
                        fromSlug: 'ufa',
                        name: 'Уфа',
                    },
                    {
                        fromSlug: 'kazan',
                        name: 'Казань',
                    },
                    {
                        fromSlug: 'samara',
                        name: 'Самара',
                    },
                    {
                        fromSlug: 'perm',
                        name: 'Пермь',
                    },
                    {
                        fromSlug: 'chelyabinsk',
                        name: 'Челябинск',
                    },
                    {
                        fromSlug: 'krasnoyarsk',
                        name: 'Красноярск',
                    },
                ],
                text: 'Какой-то вдохновляющий текст про направления в город',
                navigationTitle: 'Популярные направления',
                title: 'Популярные направления в Москву из других городов',
            },
            type: ELandingBlockType.CITY_DIRECTION_BLOCK,
        },
        {
            data: {
                navigationTitle: 'Популярные вопросы о городе',
                title: 'О чем часто спрашивают пассажиры, летящие в Москву?',
            },
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            children: [
                {
                    data: {
                        description: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    data: {
                                        text: 'В Москве 3 аэропорта — Шереметьево (SVO) Внуково (VKO) Домодедово (DME) ',
                                    },
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                },
                            ],
                        },
                        title: 'Сколько аэропортов в Москве?',
                    },
                    type: ESectionBlock.SPOILER_BLOCK,
                },
                {
                    data: {
                        description: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    data: {
                                        text: 'Ближайший аэропорт — Шереметьево, от него до центра Москвы — 100 км. От Внуково — 100 км. От Домодедово — 100 км.',
                                    },
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                },
                            ],
                        },
                        title: 'Далеко аэропорт от города?',
                    },
                    type: ESectionBlock.SPOILER_BLOCK,
                },
                {
                    data: {
                        description: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    data: {
                                        text: 'Подпишитесь на рассылку, и вы всегда будете в курсе цен. Заказывайте билеты заранее, используйте невозвратные тарифы, летайте без багажа.',
                                    },
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                },
                            ],
                        },
                        title: 'Как дешевле всего долететь до Москву?',
                    },
                    type: ESectionBlock.SPOILER_BLOCK,
                },
                {
                    data: {
                        description: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    data: {
                                        text: 'Лучший рейтинг у следующих авиакомпаний: Аэрофлот, Уральские авиалинии, S7 Airlines. Так же в Москву летают: Победа, ЮТэйр, Россия, Nordwind и другие.',
                                    },
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                },
                            ],
                        },
                        title: 'Самолёты каких авиакомпаний летают в Москву?',
                    },
                    type: ESectionBlock.SPOILER_BLOCK,
                },
            ],
        },
    ],
};
