import {ELandingBlockType} from '../common/ELandingBlockType';
import {IAviaCompaniesBlock} from '../common/IAviaCompaniesBlock';
import {IBreadCrumbsBlock} from '../common/IBreadCrumbsBlock';
import {ICityDirectionsBlock} from '../common/ICityDirectionsBlock';
import {IClosestCitiesBlock} from '../common/IClosestCitiesBlock';
import {ISearchFormBlock} from '../common/ISearchFormBlock';
import {ISectionTextBlock} from '../../../common/seo-pages/ISectionTextBlock';

interface ISearchFormBlockSearchParams {
    /**
     * ID города прибытия для предзаполнения саджеста
     */
    toId: string;
    /**
     * Открывать ли календарик по дефолту
     */
    isCalendarOpen: boolean;
}

/**
 * Блок динамиики (заголовок и описание)
 */
export interface IFlightsToDynamicsBlock {
    type: ELandingBlockType.DYNAMICS_BLOCK;
    data: {
        /**
         * Заголовок блока
         */
        title: string;
        /**
         * Заголовок блока
         */
        navigationTitle: string;
        /**
         * Описание блока
         */
        description: string;
        /**
         * ID города прилета
         */
        toId: string;
        /**
         * Дата вылета
         */
        when: string;
    };
}

export type TAviaFlightsToBlock =
    | IBreadCrumbsBlock
    | ISearchFormBlock<ISearchFormBlockSearchParams>
    | IFlightsToDynamicsBlock
    | ISectionTextBlock
    | IAviaCompaniesBlock
    | IClosestCitiesBlock
    | ICityDirectionsBlock;
