import {IPrice} from '../../../common/common';
import {ELandingBlockType} from './ELandingBlockType';
import {ILinksListBlock} from '../../../common/seo-pages/ILinksListBlock';

/**
 * Цена на перелет авиакомпанией
 */
export interface IAviaCompanyPriceBlock {
    /**
     * ID авиакомпании
     */
    id: string;
    /**
     * Название авиакомпании
     */
    name: string;
    /**
     * Стоимость перелета
     */
    price: IPrice;
    /**
     * Дата перелета
     */
    when: string;
    /**
     * Дата перелета обратно
     */
    returnDate?: string;
}

/**
 * Блок со стоимостью перелета по авиакомпаниям
 */
export interface IAviaCompaniesBlock {
    type: ELandingBlockType.AVIA_COMPANIES_BLOCK;
    data: ILinksListBlock<IAviaCompanyPriceBlock>;
}
