import {ELandingBlockType} from './ELandingBlockType';
import {IPrice} from '../../../common/common';

export interface ICityDirectionItem {
    fromSlug: string;
    name: string;
    price?: IPrice;
}

export interface ICityDirectionsBlock {
    type: ELandingBlockType.CITY_DIRECTION_BLOCK;
    data: {
        /**
         * Заголовок блока
         */
        title: string;
        /**
         * Заголовок для быстрых ссылок (если не передан - то в навигации не участвует)
         */
        navigationTitle?: string;
        /**
         * Описание блока
         */
        text?: string;
        /**
         * Список направлений с ценами
         */
        items: ICityDirectionItem[];
    };
}
