import {IPrice} from '../../../common/common';
import {ELandingBlockType} from './ELandingBlockType';
import {ILinksListBlock} from '../../../common/seo-pages/ILinksListBlock';

/**
 * Цена на перелет в город
 */
export interface ICityPriceBlock {
    /**
     * ID городв
     */
    id: string;
    /**
     * Название города
     */
    name: string;
    /**
     * Стоимость перелета
     */
    price?: IPrice;
    /**
     * Дата перелета
     */
    when: string;
    /**
     * Дата перелета обратно
     */
    returnDate?: string;
}

/**
 * Блок со стоимостью перелета в соседние города
 */
export interface IClosestCitiesBlock {
    type: ELandingBlockType.CLOSEST_CITIES_BLOCK;
    data: ILinksListBlock<ICityPriceBlock>;
}
