import {IPrice} from '../../../common/common';
import {ELandingBlockType} from './ELandingBlockType';
import {ILinksListBlock} from '../../../common/seo-pages/ILinksListBlock';

/**
 * Цена на перелет по направлению
 */
export interface IRoutePrice {
    /**
     * ID городв вылета
     */
    fromId: string;
    /**
     * ID городв прибытия
     */
    toId: string;
    /**
     * Название
     */
    name: string;
    /**
     * Стоимость перелета
     */
    price: IPrice;
    /**
     * Дата перелета
     */
    when: string;
    /**
     * Дата перелета обратно
     */
    returnDate?: string;
}

export interface IReturnTicketBlock {
    type: ELandingBlockType.RETURN_TICKET_BLOCK;
    data: ILinksListBlock<IRoutePrice>;
}
