export enum ELinkBlock {
    SEARCH_AVIA_LINK_BLOCK = 'ISearchAviaLinkBlock',
    ROUTE_LINK_BLOCK = 'IRouteLinkBlock',
}

/**
 * Ссылка на страницу направления (другую сео-страницу)
 */
export interface IRouteLinkBlock {
    type: ELinkBlock.ROUTE_LINK_BLOCK;
    data: {
        /**
         * Текст ссылки
         */
        text: string;
        /**
         * Slug города вылета
         */
        fromSlug: string;
        /**
         * Slug города прилета
         */
        toSlug: string;
    };
}

/**
 * Ссылка ведущая на страницу результатов поиска авиа
 */
export interface ISearchAviaLinkBlock {
    type: ELinkBlock.SEARCH_AVIA_LINK_BLOCK;
    data: {
        /**
         * Текст ссылки
         */
        text: string;
        /**
         * Количество мест для взрослых
         */
        adults: number;
        /**
         * Количество мест для детей
         */
        children?: number;
        /**
         * Количество мест для младенцев
         */
        infants?: number;
        /**
         * Id города вылета
         */
        fromId: string;
        /**
         * Id города прилета
         */
        toId: string;
        /**
         * Дата вылета
         */
        when: string;
        /**
         * Дата обратного вылета
         */
        returnDate?: string;
    };
}
