import {ESectionBlock} from 'common/seo-pages/ISectionTextBlock';
import {EPlainTextStyle} from 'common/seo-pages/EPlainTextStyle';

import {IResponse} from '../response';
import {EColor, ETariffItemType} from '../models';

const flightResponse: IResponse = {
    seoInfo: {
        title: 'Рейс SU 1404 Москва - Екатеринбург авиакомпании Аэрофлот',
        description: 'Рейс SU 1404 Москва - Екатеринбург авиакомпании Аэрофлот',
        openGraph: {
            title: 'Рейс SU 1404 Москва - Екатеринбург авиакомпании Аэрофлот',
            description:
                'Рейс SU 1404 Москва - Екатеринбург авиакомпании Аэрофлот',
            image: 'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
            imageSize: {
                height: 200,
                width: 200,
            },
        },
        schemaOrg: {},
    },
    blocks: {
        searchForm: {
            toTitle: 'Екатеринбург',
            fromId: 'c213',
            fromTitle: 'Москва',
            toId: 'c54',
            departureDate: '2020-10-31',
        },
        breadCrumbs: {
            items: [
                {
                    title: 'Авиа',
                    link: '/avia/',
                },
                {
                    title: 'Москва - Екатеринбург',
                    link: '/avia/route/moscow--yekaterinburg/',
                },
                {
                    title: 'SU 1404',
                },
            ],
        },
        flightTitle: {
            title: 'Рейс SU 1404 Москва - Екатеринбург авиакомпании Аэрофлот',
        },
        flightDates: {
            items: [
                {
                    departureDate: '2020-10-08',
                    shownDepartureDate: '8 окт, вт',
                    selected: false,
                },
                {
                    departureDate: '2020-10-09',
                    shownDepartureDate: '9 окт, ср',
                    selected: true,
                },
                {
                    departureDate: '2020-10-10',
                    shownDepartureDate: '10 окт, чт',
                    selected: false,
                },
            ],
        },
        flight: {
            segments: [
                {
                    arrival: {
                        title: 'Екатеринбург',
                        stationTitle: 'Кольцово',
                        settlementTitle: 'Екатеринбург',
                        stationCode: 'SVX',
                        formattedDate: '6 окт',
                        dateColor: EColor.BLACK,
                        gate: null,
                        gateColor: EColor.GREY,
                        scheduledTime: '2020-10-08 07:50:00',
                        terminal: 'A',
                        terminalColor: EColor.GREY,
                        actualTime: '2020-10-08 07:55:00',
                        timeColor: EColor.GREY,
                    },
                    departure: {
                        title: 'Москва',
                        stationTitle: 'Шереметьево',
                        settlementTitle: 'Москва',
                        stationCode: 'SVO',
                        formattedDate: '6 окт',
                        dateColor: EColor.BLACK,
                        gate: '21',
                        gateColor: EColor.GREY,
                        scheduledTime: '2020-10-08 05:50:00',
                        terminal: null,
                        terminalColor: EColor.GREY,
                        actualTime: '2020-10-08 05:55:00',
                        timeColor: EColor.GREY,
                    },
                    duration: {
                        inAir: '42 мин',
                        passed: 0.22586977071245615,
                        total: '3 ч 10 мин',
                    },
                    lastUpdate: 'Данные обновлены 2 мин назад',
                    status: {
                        code: 'on_time',
                        baggageCarousels: null,
                        baggageCarouselsColor: EColor.GREY,
                        checkInDesks: null,
                        checkInDesksColor: EColor.GREY,
                        departsSoon: true,
                        text: 'По расписанию',
                        textColor: EColor.GREEN,
                    },
                    selected: true,
                },
            ],
        },
        map: {
            flightPointCoordinates: [
                {latitude: 55.753676, longitude: 37.619899},
                {latitude: 56.838607, longitude: 60.605514},
            ],
        },
        disclaimer: {
            text: 'На основе данных flightstats.com. Данные носят справочный характер, уточняйте их у перевозчика. Яндекс не несет ответственности за актуальность и достоверность представленной информации.',
        },
        additionalInfo: {
            tariffs: {
                title: 'Тарифы',
                items: [
                    {
                        title: 'Эконом промо',
                        items: [
                            {
                                type: ETariffItemType.CARRY_ON,
                                description: '1 место, 10 кг',
                                color: EColor.BLACK,
                            },
                            {
                                type: ETariffItemType.BAGGAGE,
                                description: '1 место, 5 кг, 55×40×25',
                                color: EColor.BLACK,
                            },
                            {
                                type: ETariffItemType.MILES,
                                description: 'Мили: 75% миль',
                                color: EColor.GREEN,
                            },
                        ],
                    },
                ],
            },
            baggage: {
                title: 'Багаж',
                description:
                    'Количество мест багажна зависит от выбранного тарифа',
                baggageRestrictions: {
                    title: 'Ограничение габаритов',
                    carryOn: {
                        type: ETariffItemType.CARRY_ON,
                        description: 'Ручная кладь до 10 кг, 40х55х20 см',
                        color: EColor.BLACK,
                    },
                    baggage: {
                        type: ETariffItemType.BAGGAGE,
                        description: 'Багаж 20 кг',
                        color: EColor.BLACK,
                    },
                },
            },
            flightRating: {
                title: 'Статистика полетов',
                items: [
                    {
                        text: 'По расписанию',
                        percent: '85%',
                    },
                    {
                        text: 'Задерживается на 15–20 мин',
                        percent: '7%',
                    },
                ],
            },
            aircraftType: {
                title: 'Тип самолета',
                aircraftType: 'Airbus 319',
            },
            seoText: {
                type: ESectionBlock.SECTION_TEXT_BLOCK,
                data: {
                    title: 'Тип самолета',
                },
                children: [
                    {
                        type: ESectionBlock.TEXT_BLOCK,
                        children: [
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: 'Подробнее о правилах провоза багажа, что можно и нельзя брать с собой в ручную кладь, питании на борту можно узнать',
                                },
                            },
                            {
                                type: ESectionBlock.EXTERNAL_LINK_BLOCK,
                                data: {
                                    text: 'на странице об авиакомпании',
                                    url: 'https://some-airline.com',
                                },
                            },
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: '.',
                                },
                            },
                        ],
                    },
                    {
                        type: ESectionBlock.TEXT_BLOCK,
                        children: [
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: 'Кроме того, в правилах авиакомпании перечислены предметы, которые тоже могут лететь в салоне. Это дамская сумочка или мужской портфель, папка для бумаг, зонтик, трость, букет цветов, верхняя одежда, печатные издания для чтения в полёте, детское питание на время полёта, детская люлька при перевозе ребёнка, костюм в портпледе, костыли, товары, приобретенные в магазинах беспошлинной торговли в аэропорту, упакованные в один запечатанный (опломбированный) пластиковый пакет, с габаритами по сумме трех измерений не более 115 см. ',
                                },
                            },
                        ],
                    },
                ],
            },
        },
        tickets: {
            text: {
                title: 'Билеты',
                minPriceText: 'от 999 ₽',
                text: [
                    {
                        type: ESectionBlock.TEXT_BLOCK,
                        children: [
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: '22 января, среда, 1 пассажир',
                                    styles: [EPlainTextStyle.BOLD_STYLE],
                                },
                            },
                        ],
                    },
                    {
                        type: ESectionBlock.TEXT_BLOCK,
                        children: [
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: 'без багажа, эконом-класс',
                                },
                            },
                        ],
                    },
                ],
            },
            directOffers: {
                bestOffer: {
                    title: 'Лушая цена',
                    offer: {
                        partnerCode: 'partner_1',
                        price: {currency: '₽', value: 999},
                        allOffersLink: '/avia',
                        offerPageLink: '/avia',
                    },
                },
                offers: [
                    {
                        partnerCode: 'partner_1',
                        price: {currency: '₽', value: 999},
                        allOffersLink: '/avia',
                        offerPageLink: '/avia',
                    },
                    {
                        partnerCode: 'partner_2',
                        price: {currency: '₽', value: 1999},
                        allOffersLink: '/avia',
                        offerPageLink: '/avia',
                    },
                ],
            },
            button: {
                text: 'Найти билеты на этот рейс',
                link: '/',
            },
        },
        usefulLinks: {
            title: 'Полезные ссылки',
            items: [
                {
                    type: ESectionBlock.EXTERNAL_LINK_BLOCK,
                    data: {
                        text: 'Официальный сайт авиакомпании',
                        url: 'https://some-airline.com',
                    },
                },
            ],
        },
        flightSeoText: {
            title: 'Информация о рейсе SU 1404 Москва — Екатеринбург',
            description:
                'Рейс SU 1404 авиакомпании Аэрофлот вылетает из аэропорта Домодедово, терминал Е и прибывает в Колцово, терминал А. Дальность полёта составляет 1200 км. Среднее время полета составляет 2 часа, 15 минут',
        },
    },
};

export default flightResponse;
