import {ICoordinates} from 'common/common';
import {ISeoInfo} from 'common/seo-pages/ISeoInfo';
import {
    IExternalLinkBlock,
    ISectionTextBlock,
    TSectionTextChildBlock,
    TTextChildBlock,
} from 'common/seo-pages/ISectionTextBlock';

import {IBreadCrumbItem} from '../common/IBreadCrumbsBlock';

export interface IFlightSeoInfo extends ISeoInfo<IFlightSchemaOrgInfo> {}

export interface IFlightSchemaOrgInfo {}

export interface ISearchFormBlock {
    fromTitle: string;
    toTitle: string;
    fromId: string;
    toId: string;
    departureDate: string;
}

export interface IBreadCrumbsBlock {
    items: IBreadCrumbItem[];
}

export interface IFlightTitleBlock {
    title: string;
}

export interface IFlightDatesBlock {
    items: IFlightDate[];
}

export interface IFlightDate {
    departureDate: string;
    shownDepartureDate: string;
    selected: boolean;
}

export interface IFlightBlock {
    segments: IFlightSegment[];
}

export enum EColor {
    BLACK = 'black',
    RED = 'red',
    GREY = 'grey',
    GREEN = 'green',
    YELLOW = 'yellow',
}

export interface ISegmentPoint {
    title: string;
    stationTitle: string;
    settlementTitle: string;
    stationCode: string;
    formattedDate: string;
    dateColor: EColor;
    gate: string | null;
    gateColor: EColor;
    scheduledTime: string;
    terminal: string | null;
    terminalColor: EColor;
    actualTime: string | null;
    timeColor: EColor;
}

export interface ISegmentDuration {
    inAir: string;
    passed: number;
    total: string;
}

export interface IFlightStatus {
    code: string;
    baggageCarousels: string | null;
    baggageCarouselsColor: EColor;
    checkInDesks: string | null;
    checkInDesksColor: EColor;
    departsSoon: boolean;
    text: string;
    textColor: EColor;
}

export interface IFlightSegment {
    arrival: ISegmentPoint;
    departure: ISegmentPoint;
    duration: ISegmentDuration;
    lastUpdate: string;
    status: IFlightStatus;
    selected: boolean;
}

export interface IMapBlock {
    flightPointCoordinates: ICoordinates[];
}

export interface IDisclaimerBlock {
    text: string;
}

export enum ETariffItemType {
    CARRY_ON = 'carryOn',
    BAGGAGE = 'baggage',
    MILES = 'miles',
    REFUNDABLE = 'refundable',
    SEAT_SELECTION_CHECK_IN = 'seatSelectionCheckIn',
    CHANGING_CARRIAGE = 'changingCarriage',
}

export interface ITariffInfoItem {
    type: ETariffItemType;
    description: string;
    color: EColor;
}

export interface ITariff {
    title: string;
    items: ITariffInfoItem[];
}

export interface IBaggageRestrictions {
    title: string;
    carryOn?: ITariffInfoItem;
    baggage?: ITariffInfoItem;
}

export interface IBaggage {
    title: string;
    description: string;
    baggageRestrictions?: IBaggageRestrictions;
}

export interface IFlightRatingItem {
    text: string;
    percent: string;
}

export interface IFlightRating {
    title: string;
    items: IFlightRatingItem[];
}

export interface IAircraftType {
    title: string;
    aircraftType: string;
}

export interface ITariffs {
    title: string;
    items: ITariff[];
}

export interface IAdditionalInfoBlock {
    tariffs?: ITariffs;
    baggage?: IBaggage;
    flightRating?: IFlightRating;
    aircraftType?: IAircraftType;
    seoText?: ISectionTextBlock;
}

export interface ITicketsButton {
    text: string;
    link: string;
}

export interface IOfferPrice {
    currency: string;
    value: number;
}

export interface ITicketOffer {
    partnerCode: string;
    price: IOfferPrice;
    allOffersLink: string;
    offerPageLink: string;
}

export interface IBestOffer {
    title: string;
    offer: ITicketOffer;
}

export interface ITicketOffers {
    bestOffer: IBestOffer;
    offers: ITicketOffer[];
}

export interface ITicketsTextBlock {
    title: string;
    minPriceText?: string;
    text: TSectionTextChildBlock[];
}

export interface ITicketsBlock {
    text: ITicketsTextBlock;
    directOffersTitle?: string;
    directOffers?: ITicketOffers;
    indirectOffersTitle?: string;
    indirectOffers?: ITicketOffers;
    showAllOffersLink?: IExternalLinkBlock;
    button?: ITicketsButton;
}

export interface IUsefulLinksBlock {
    title: string;
    items: TTextChildBlock[];
}

export interface IFlightSeoTextBlock {
    title: string;
    description: string;
}
