import {ECurrencyType} from 'common/common';
import {EPlainTextStyle} from 'common/seo-pages/EPlainTextStyle';
import {ESectionBlock} from 'common/seo-pages/ISectionTextBlock';

import {IResponse} from '../response';
import {ELandingBlockType} from '../../common/ELandingBlockType';

const geoRegionResponse: IResponse = {
    seoInfo: {
        title: 'Дешевые авиабилеты Москва-Сочи',
        description: 'Дешевые авиабилеты Москва-Сочи находятся здесь',
        openGraph: {
            title: 'openGraph название страницы',
            description: 'openGraph описание страницы',
            image: 'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
            imageSize: {
                height: 200,
                width: 200,
            },
        },
        schemaOrg: {
            faqItems: [
                {
                    question: 'Кто в Сочи не бывал',
                    answer: 'Красоты не видал.',
                },
                {
                    question: 'Ну Армянин!',
                    answer: 'Жизнь висит на нитке, а думает о мангале.',
                },
            ],
        },
    },
    blocks: [
        {
            type: ELandingBlockType.BREAD_CRUMBS_BLOCK,
            data: {
                items: [
                    {
                        title: 'Авиа',
                        link: 'https://travel.yandex.ru/avia/',
                    },
                    {
                        title: 'Москва - Сочи',
                    },
                ],
            },
        },
        {
            type: ELandingBlockType.SEARCH_FORM_BLOCK,
            data: {
                title: 'Дешёвые авиабилеты Москва – Сочи находятся здесь',
                imageUrl:
                    'https://avatars.mds.yandex.net/get-altay/1860543/2a0000016f76e6ef2964853a440b016ea007/orig',
                searchFormParams: {
                    isCalendarOpen: true,
                    fromId: 'c213',
                    toId: 'c239',
                },
            },
        },
        {
            type: ELandingBlockType.DYNAMICS_BLOCK,
            data: {
                title: 'Динамика цен на авиабилеты Москва – Сочи',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
                description:
                    'Календарь цен позволит найти оптимальные по стоимости и времени отправления рейсы по направлению Москва –  Сочи',
                fromId: 'c213',
                toId: 'c239',
                when: '2020-12-10',
            },
        },
        {
            type: ESectionBlock.SECTION_TEXT_BLOCK,
            data: {
                title: 'Заголовк текстового блока большой',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
            },
            children: [
                {
                    type: ESectionBlock.TEXT_BLOCK,
                    children: [
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'Город? Город - страшная сила. А чем больше город, тем она сильнее. Он засасывает. Только сильный может выкарабкаться.',
                            },
                        },
                    ],
                },
                {
                    type: ESectionBlock.TEXT_BLOCK,
                    children: [
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'Город - ',
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'злая ',
                                styles: [EPlainTextStyle.BOLD_STYLE],
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'сила. Сильный приезжает, становится ',
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'слабым. ',
                                styles: [EPlainTextStyle.ITALIC_STYLE],
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'Город забирает силу. Вот и ты ',
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'пропал.',
                                styles: [
                                    EPlainTextStyle.ITALIC_STYLE,
                                    EPlainTextStyle.BOLD_STYLE,
                                ],
                            },
                        },
                    ],
                },
            ],
        },
        {
            type: ELandingBlockType.AVIA_COMPANIES_BLOCK,
            data: {
                title: 'Цены на перелеты из Москвы в Сочи по авиакомпаниям',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
                description:
                    'Авиабилеты на прямые рейсы Москвы в Сочи вы можете купить у 14 авиакомпаний. Самые низкие цены на перелет предлагает авиакомпания Победа.',
                items: [
                    {
                        id: '26',
                        name: 'Аэрофлот',
                        when: '2020-10-12',
                        price: {
                            value: 2222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                    {
                        id: '80',
                        name: 'Нордавиа',
                        when: '2020-10-12',
                        price: {
                            value: 1222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                    {
                        id: '26',
                        name: 'Аэрофлот',
                        when: '2020-10-12',
                        price: {
                            value: 2222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                    {
                        id: '80',
                        name: 'Нордавиа',
                        when: '2020-10-12',
                        price: {
                            value: 1222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                ],
            },
        },
        {
            type: ELandingBlockType.CLOSEST_CITIES_BLOCK,
            data: {
                title: 'Авиабилеты из Москва в ближайшие с Сочи города',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
                description: 'Рейсы до городов рядом могут быть дешевле',
                items: [
                    {
                        id: 'c239',
                        name: 'Сочи',
                        when: '2020-10-20',
                        price: {
                            value: 2222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                    {
                        id: 'c213',
                        name: 'Москва',
                        when: '2020-10-20',
                        price: {
                            value: 2222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                ],
            },
        },
        {
            type: ELandingBlockType.RETURN_TICKET_BLOCK,
            data: {
                title: 'Обратный авиабилет из Сочи в Москву',
                navigationTitle:
                    'А этот заголовок вынесем в правую колонку в быстрые ссылки',
                items: [
                    {
                        fromId: 'c239',
                        toId: 'с213',
                        name: 'Сочи – Москва',
                        when: '2020-10-30',
                        price: {
                            value: 2222,
                            currency: ECurrencyType.RUB,
                        },
                    },
                ],
            },
        },
    ],
};

export default geoRegionResponse;
