import {ELandingBlockType} from '../common/ELandingBlockType';
import {IAviaCompaniesBlock} from '../common/IAviaCompaniesBlock';
import {IBreadCrumbsBlock} from '../common/IBreadCrumbsBlock';
import {IClosestCitiesBlock} from '../common/IClosestCitiesBlock';
import {IReturnTicketBlock} from '../common/IReturnTicketBlock';
import {ISearchFormBlock} from '../common/ISearchFormBlock';
import {ISectionTextBlock} from '../../../common/seo-pages/ISectionTextBlock';
import {ITransportRoutesBlock} from '../../../common/seo-pages/ITransportRoutesBlock';
import {ICrossSaleHotelsBlock} from '../../../common/seo-pages/ICrossSaleHotelsBlock';

interface ISearchFormBlockSearchParams {
    /**
     * ID города отправления для предзаполнения саджеста
     */
    fromId: string;
    /**
     * ID города прибытия для предзаполнения саджеста
     */
    toId: string;
    /**
     * Открывать ли календарик по дефолту
     */
    isCalendarOpen: boolean;
}

/**
 * Блок динамиики (заголовок и описание)
 */
export interface IDynamicsBlock {
    type: ELandingBlockType.DYNAMICS_BLOCK;
    data: {
        /**
         * Заголовок блока
         */
        title: string;
        /**
         * Заголовок для быстрых ссылок (если не передан - то в навигации не участвует)
         */
        navigationTitle?: string;
        /**
         * Описание блока
         */
        description?: string;
        /**
         * ID города вылета
         */
        fromId: string;
        /**
         * ID города прилета
         */
        toId: string;
        /**
         * Дата вылета
         */
        when: string;
    };
}

/**
 * Верхнеуровневые блоки
 */
export type TAviaRouteBlock =
    | IBreadCrumbsBlock
    | ISearchFormBlock<ISearchFormBlockSearchParams>
    | ISectionTextBlock
    | IDynamicsBlock
    | IAviaCompaniesBlock
    | IClosestCitiesBlock
    | ITransportRoutesBlock
    | IReturnTicketBlock
    | ICrossSaleHotelsBlock;
