import {TDate} from 'common/common';

import {TSettlementKey, TStationKey} from '../../common/PointKey';

enum ERegion {
    RUSSIA = 'russia',
    CIS = 'cis',
    EUROPE = 'europe',
    ASIA = 'asia',
    AMERICA = 'america',
}

enum ECovidRestrictionType {
    PCR_TEST_REQUIRED = 'pcrTestRequired',
    SPUTNIK_V = 'sputnikV',
    WHO_VACCINES = 'whoVaccines',
}

enum EBankCardType {
    RUSSIAN_VISA_MASTERCARD = 'russianVisaMastercard',
    MIR = 'mir',
    UNION_PAY = 'unionPay',
}

export interface IWherePossibleRequest {
    from: TSettlementKey | TStationKey;
    dateForward: TDate;
    dateBackward?: TDate;

    withoutTransfer: boolean;
    withoutVisa: boolean;

    regions: ERegion[];
    covidRestrictions: ECovidRestrictionType[];
    noQuarantine: boolean;
    bankCardAcceptance: EBankCardType[];
}
